<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class Documentation extends \Google\Collection
{
  protected $collection_key = 'links';
  /**
   * The body of the documentation, interpreted according to mime_type. The
   * content may not exceed 8,192 Unicode characters and may not exceed more
   * than 10,240 bytes when encoded in UTF-8 format, whichever is smaller. This
   * text can be templatized by using variables
   * (https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
   *
   * @var string
   */
  public $content;
  protected $linksType = Link::class;
  protected $linksDataType = 'array';
  /**
   * The format of the content field. Presently, only the value "text/markdown"
   * is supported. See Markdown (https://en.wikipedia.org/wiki/Markdown) for
   * more information.
   *
   * @var string
   */
  public $mimeType;
  /**
   * Optional. The subject line of the notification. The subject line may not
   * exceed 10,240 bytes. In notifications generated by this policy, the
   * contents of the subject line after variable expansion will be truncated to
   * 255 bytes or shorter at the latest UTF-8 character boundary. The 255-byte
   * limit is recommended by this thread
   * (https://stackoverflow.com/questions/1592291/what-is-the-email-subject-
   * length-limit). It is both the limit imposed by some third-party ticketing
   * products and it is common to define textual fields in databases as
   * VARCHAR(255).The contents of the subject line can be templatized by using
   * variables (https://cloud.google.com/monitoring/alerts/doc-variables#doc-
   * vars). If this field is missing or empty, a default subject line will be
   * generated.
   *
   * @var string
   */
  public $subject;

  /**
   * The body of the documentation, interpreted according to mime_type. The
   * content may not exceed 8,192 Unicode characters and may not exceed more
   * than 10,240 bytes when encoded in UTF-8 format, whichever is smaller. This
   * text can be templatized by using variables
   * (https://cloud.google.com/monitoring/alerts/doc-variables#doc-vars).
   *
   * @param string $content
   */
  public function setContent($content)
  {
    $this->content = $content;
  }
  /**
   * @return string
   */
  public function getContent()
  {
    return $this->content;
  }
  /**
   * Optional. Links to content such as playbooks, repositories, and other
   * resources. This field can contain up to 3 entries.
   *
   * @param Link[] $links
   */
  public function setLinks($links)
  {
    $this->links = $links;
  }
  /**
   * @return Link[]
   */
  public function getLinks()
  {
    return $this->links;
  }
  /**
   * The format of the content field. Presently, only the value "text/markdown"
   * is supported. See Markdown (https://en.wikipedia.org/wiki/Markdown) for
   * more information.
   *
   * @param string $mimeType
   */
  public function setMimeType($mimeType)
  {
    $this->mimeType = $mimeType;
  }
  /**
   * @return string
   */
  public function getMimeType()
  {
    return $this->mimeType;
  }
  /**
   * Optional. The subject line of the notification. The subject line may not
   * exceed 10,240 bytes. In notifications generated by this policy, the
   * contents of the subject line after variable expansion will be truncated to
   * 255 bytes or shorter at the latest UTF-8 character boundary. The 255-byte
   * limit is recommended by this thread
   * (https://stackoverflow.com/questions/1592291/what-is-the-email-subject-
   * length-limit). It is both the limit imposed by some third-party ticketing
   * products and it is common to define textual fields in databases as
   * VARCHAR(255).The contents of the subject line can be templatized by using
   * variables (https://cloud.google.com/monitoring/alerts/doc-variables#doc-
   * vars). If this field is missing or empty, a default subject line will be
   * generated.
   *
   * @param string $subject
   */
  public function setSubject($subject)
  {
    $this->subject = $subject;
  }
  /**
   * @return string
   */
  public function getSubject()
  {
    return $this->subject;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Documentation::class, 'Google_Service_Monitoring_Documentation');
