<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contactcenterinsights;

class GoogleCloudContactcenterinsightsV1GenerativeInsightsRequest extends \Google\Model
{
  /**
   * The full name of the chart resource this request corresponds to. Format: pr
   * ojects/{project}/locations/{location}/dashboards/{dashboard}/charts/{chart}
   *
   * @var string
   */
  public $chart;
  /**
   * Optional. Filter for the data that can be specified in addition to the
   * natural language query. This `filter` is specifically used for charts where
   * comparisons are possible. For example, "compare to last month" or "compare
   * to previous quarter".
   *
   * @var string
   */
  public $comparisonFilter;
  /**
   * Filter for the data that can be specified in addition to the natural
   * language query. Users are encouraged to use this field to populate time-
   * windows.
   *
   * @var string
   */
  public $filter;
  /**
   * The natural language query specified by the user. If this field is
   * specified, `sql_query` will be ignored.
   *
   * @var string
   */
  public $naturalLanguageQuery;
  /**
   * Optional. The revision id that maps to the state of the chart state
   * revision. When specified, the backend will reload the chart with the sql
   * and visual spec from that revision.
   *
   * @var string
   */
  public $revisionId;
  /**
   * Optional. The session id of the conversation. If the session id is not
   * specified, backend will generate a random session id. If the session id is
   * specified, will associate user-provided user_query with the provided
   * session id.
   *
   * @var string
   */
  public $sessionId;
  /**
   * Optional. For charts with comparison, this key will determine the metric
   * that will be compared between the current and another dataset.
   *
   * @var string
   */
  public $sqlComparisonKey;
  /**
   * Optional. The SQL query specified by the user. This query must be in
   * BigQuery SQL dialect. The `filter` field will also be ignored, as it is
   * assumed that any filtering is already included in the SQL query.
   *
   * @var string
   */
  public $sqlQuery;
  /**
   * Optional. The user provided chart spec for the chart. This will be used to
   * override the visual spec generated by the LLM.
   *
   * @var array[]
   */
  public $userProvidedChartSpec;

  /**
   * The full name of the chart resource this request corresponds to. Format: pr
   * ojects/{project}/locations/{location}/dashboards/{dashboard}/charts/{chart}
   *
   * @param string $chart
   */
  public function setChart($chart)
  {
    $this->chart = $chart;
  }
  /**
   * @return string
   */
  public function getChart()
  {
    return $this->chart;
  }
  /**
   * Optional. Filter for the data that can be specified in addition to the
   * natural language query. This `filter` is specifically used for charts where
   * comparisons are possible. For example, "compare to last month" or "compare
   * to previous quarter".
   *
   * @param string $comparisonFilter
   */
  public function setComparisonFilter($comparisonFilter)
  {
    $this->comparisonFilter = $comparisonFilter;
  }
  /**
   * @return string
   */
  public function getComparisonFilter()
  {
    return $this->comparisonFilter;
  }
  /**
   * Filter for the data that can be specified in addition to the natural
   * language query. Users are encouraged to use this field to populate time-
   * windows.
   *
   * @param string $filter
   */
  public function setFilter($filter)
  {
    $this->filter = $filter;
  }
  /**
   * @return string
   */
  public function getFilter()
  {
    return $this->filter;
  }
  /**
   * The natural language query specified by the user. If this field is
   * specified, `sql_query` will be ignored.
   *
   * @param string $naturalLanguageQuery
   */
  public function setNaturalLanguageQuery($naturalLanguageQuery)
  {
    $this->naturalLanguageQuery = $naturalLanguageQuery;
  }
  /**
   * @return string
   */
  public function getNaturalLanguageQuery()
  {
    return $this->naturalLanguageQuery;
  }
  /**
   * Optional. The revision id that maps to the state of the chart state
   * revision. When specified, the backend will reload the chart with the sql
   * and visual spec from that revision.
   *
   * @param string $revisionId
   */
  public function setRevisionId($revisionId)
  {
    $this->revisionId = $revisionId;
  }
  /**
   * @return string
   */
  public function getRevisionId()
  {
    return $this->revisionId;
  }
  /**
   * Optional. The session id of the conversation. If the session id is not
   * specified, backend will generate a random session id. If the session id is
   * specified, will associate user-provided user_query with the provided
   * session id.
   *
   * @param string $sessionId
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
  }
  /**
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }
  /**
   * Optional. For charts with comparison, this key will determine the metric
   * that will be compared between the current and another dataset.
   *
   * @param string $sqlComparisonKey
   */
  public function setSqlComparisonKey($sqlComparisonKey)
  {
    $this->sqlComparisonKey = $sqlComparisonKey;
  }
  /**
   * @return string
   */
  public function getSqlComparisonKey()
  {
    return $this->sqlComparisonKey;
  }
  /**
   * Optional. The SQL query specified by the user. This query must be in
   * BigQuery SQL dialect. The `filter` field will also be ignored, as it is
   * assumed that any filtering is already included in the SQL query.
   *
   * @param string $sqlQuery
   */
  public function setSqlQuery($sqlQuery)
  {
    $this->sqlQuery = $sqlQuery;
  }
  /**
   * @return string
   */
  public function getSqlQuery()
  {
    return $this->sqlQuery;
  }
  /**
   * Optional. The user provided chart spec for the chart. This will be used to
   * override the visual spec generated by the LLM.
   *
   * @param array[] $userProvidedChartSpec
   */
  public function setUserProvidedChartSpec($userProvidedChartSpec)
  {
    $this->userProvidedChartSpec = $userProvidedChartSpec;
  }
  /**
   * @return array[]
   */
  public function getUserProvidedChartSpec()
  {
    return $this->userProvidedChartSpec;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudContactcenterinsightsV1GenerativeInsightsRequest::class, 'Google_Service_Contactcenterinsights_GoogleCloudContactcenterinsightsV1GenerativeInsightsRequest');
