<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class StoragePool extends \Google\Model
{
  /**
   * Advanced provisioning "thinly" allocates the related resource.
   */
  public const CAPACITY_PROVISIONING_TYPE_ADVANCED = 'ADVANCED';
  /**
   * Standard provisioning allocates the related resource for the pool disks'
   * exclusive use.
   */
  public const CAPACITY_PROVISIONING_TYPE_STANDARD = 'STANDARD';
  public const CAPACITY_PROVISIONING_TYPE_UNSPECIFIED = 'UNSPECIFIED';
  /**
   * Advanced provisioning "thinly" allocates the related resource.
   */
  public const PERFORMANCE_PROVISIONING_TYPE_ADVANCED = 'ADVANCED';
  /**
   * Standard provisioning allocates the related resource for the pool disks'
   * exclusive use.
   */
  public const PERFORMANCE_PROVISIONING_TYPE_STANDARD = 'STANDARD';
  public const PERFORMANCE_PROVISIONING_TYPE_UNSPECIFIED = 'UNSPECIFIED';
  /**
   * StoragePool is provisioning
   */
  public const STATE_CREATING = 'CREATING';
  /**
   * StoragePool is deleting.
   */
  public const STATE_DELETING = 'DELETING';
  /**
   * StoragePool creation failed.
   */
  public const STATE_FAILED = 'FAILED';
  /**
   * StoragePool is ready for use.
   */
  public const STATE_READY = 'READY';
  /**
   * Provisioning type of the byte capacity of the pool.
   *
   * @var string
   */
  public $capacityProvisioningType;
  /**
   * Output only. [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  protected $exapoolProvisionedCapacityGbType = StoragePoolExapoolProvisionedCapacityGb::class;
  protected $exapoolProvisionedCapacityGbDataType = '';
  /**
   * Output only. [Output Only] The unique identifier for the resource. This
   * identifier is defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * Output only. [Output Only] Type of the resource. Always compute#storagePool
   * for storage pools.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this storage pool, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a storage
   * pool.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels to apply to this storage pool. These can be later modified by the
   * setLabels method.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  protected $paramsType = StoragePoolParams::class;
  protected $paramsDataType = '';
  /**
   * Provisioning type of the performance-related parameters of the pool, such
   * as throughput and IOPS.
   *
   * @var string
   */
  public $performanceProvisioningType;
  /**
   * Size of the storage pool in GiB. For more information about the size
   * limits, see https://cloud.google.com/compute/docs/disks/storage-pools.
   *
   * @var string
   */
  public $poolProvisionedCapacityGb;
  /**
   * Provisioned IOPS of the storage pool. Only relevant if the storage pool
   * type is hyperdisk-balanced.
   *
   * @var string
   */
  public $poolProvisionedIops;
  /**
   * Provisioned throughput of the storage pool in MiB/s. Only relevant if the
   * storage pool type is hyperdisk-balanced or hyperdisk-throughput.
   *
   * @var string
   */
  public $poolProvisionedThroughput;
  protected $resourceStatusType = StoragePoolResourceStatus::class;
  protected $resourceStatusDataType = '';
  /**
   * Output only. [Output Only] Server-defined fully-qualified URL for this
   * resource.
   *
   * @var string
   */
  public $selfLink;
  /**
   * Output only. [Output Only] Server-defined URL for this resource's resource
   * id.
   *
   * @var string
   */
  public $selfLinkWithId;
  /**
   * Output only. [Output Only] The status of storage pool creation.
   * - CREATING: Storage pool is provisioning.      storagePool.      - FAILED:
   * Storage pool creation failed.      - READY: Storage pool is ready for use.
   * - DELETING: Storage pool is deleting.
   *
   * @var string
   */
  public $state;
  protected $statusType = StoragePoolResourceStatus::class;
  protected $statusDataType = '';
  /**
   * Type of the storage pool.
   *
   * @var string
   */
  public $storagePoolType;
  /**
   * Output only. [Output Only] URL of the zone where the storage pool resides.
   * You must specify this field as part of the HTTP request URL. It is not
   * settable as a field in the request body.
   *
   * @var string
   */
  public $zone;

  /**
   * Provisioning type of the byte capacity of the pool.
   *
   * Accepted values: ADVANCED, STANDARD, UNSPECIFIED
   *
   * @param self::CAPACITY_PROVISIONING_TYPE_* $capacityProvisioningType
   */
  public function setCapacityProvisioningType($capacityProvisioningType)
  {
    $this->capacityProvisioningType = $capacityProvisioningType;
  }
  /**
   * @return self::CAPACITY_PROVISIONING_TYPE_*
   */
  public function getCapacityProvisioningType()
  {
    return $this->capacityProvisioningType;
  }
  /**
   * Output only. [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Output only. [Output Only] Provisioned capacities for each SKU for this
   * Exapool in GiB
   *
   * @param StoragePoolExapoolProvisionedCapacityGb $exapoolProvisionedCapacityGb
   */
  public function setExapoolProvisionedCapacityGb(StoragePoolExapoolProvisionedCapacityGb $exapoolProvisionedCapacityGb)
  {
    $this->exapoolProvisionedCapacityGb = $exapoolProvisionedCapacityGb;
  }
  /**
   * @return StoragePoolExapoolProvisionedCapacityGb
   */
  public function getExapoolProvisionedCapacityGb()
  {
    return $this->exapoolProvisionedCapacityGb;
  }
  /**
   * Output only. [Output Only] The unique identifier for the resource. This
   * identifier is defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Output only. [Output Only] Type of the resource. Always compute#storagePool
   * for storage pools.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this storage pool, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a storage
   * pool.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels to apply to this storage pool. These can be later modified by the
   * setLabels method.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Input only. Additional params passed with the request, but not persisted as
   * part of resource payload.
   *
   * @param StoragePoolParams $params
   */
  public function setParams(StoragePoolParams $params)
  {
    $this->params = $params;
  }
  /**
   * @return StoragePoolParams
   */
  public function getParams()
  {
    return $this->params;
  }
  /**
   * Provisioning type of the performance-related parameters of the pool, such
   * as throughput and IOPS.
   *
   * Accepted values: ADVANCED, STANDARD, UNSPECIFIED
   *
   * @param self::PERFORMANCE_PROVISIONING_TYPE_* $performanceProvisioningType
   */
  public function setPerformanceProvisioningType($performanceProvisioningType)
  {
    $this->performanceProvisioningType = $performanceProvisioningType;
  }
  /**
   * @return self::PERFORMANCE_PROVISIONING_TYPE_*
   */
  public function getPerformanceProvisioningType()
  {
    return $this->performanceProvisioningType;
  }
  /**
   * Size of the storage pool in GiB. For more information about the size
   * limits, see https://cloud.google.com/compute/docs/disks/storage-pools.
   *
   * @param string $poolProvisionedCapacityGb
   */
  public function setPoolProvisionedCapacityGb($poolProvisionedCapacityGb)
  {
    $this->poolProvisionedCapacityGb = $poolProvisionedCapacityGb;
  }
  /**
   * @return string
   */
  public function getPoolProvisionedCapacityGb()
  {
    return $this->poolProvisionedCapacityGb;
  }
  /**
   * Provisioned IOPS of the storage pool. Only relevant if the storage pool
   * type is hyperdisk-balanced.
   *
   * @param string $poolProvisionedIops
   */
  public function setPoolProvisionedIops($poolProvisionedIops)
  {
    $this->poolProvisionedIops = $poolProvisionedIops;
  }
  /**
   * @return string
   */
  public function getPoolProvisionedIops()
  {
    return $this->poolProvisionedIops;
  }
  /**
   * Provisioned throughput of the storage pool in MiB/s. Only relevant if the
   * storage pool type is hyperdisk-balanced or hyperdisk-throughput.
   *
   * @param string $poolProvisionedThroughput
   */
  public function setPoolProvisionedThroughput($poolProvisionedThroughput)
  {
    $this->poolProvisionedThroughput = $poolProvisionedThroughput;
  }
  /**
   * @return string
   */
  public function getPoolProvisionedThroughput()
  {
    return $this->poolProvisionedThroughput;
  }
  /**
   * Output only. [Output Only] Status information for the storage pool
   * resource.
   *
   * @param StoragePoolResourceStatus $resourceStatus
   */
  public function setResourceStatus(StoragePoolResourceStatus $resourceStatus)
  {
    $this->resourceStatus = $resourceStatus;
  }
  /**
   * @return StoragePoolResourceStatus
   */
  public function getResourceStatus()
  {
    return $this->resourceStatus;
  }
  /**
   * Output only. [Output Only] Server-defined fully-qualified URL for this
   * resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * Output only. [Output Only] Server-defined URL for this resource's resource
   * id.
   *
   * @param string $selfLinkWithId
   */
  public function setSelfLinkWithId($selfLinkWithId)
  {
    $this->selfLinkWithId = $selfLinkWithId;
  }
  /**
   * @return string
   */
  public function getSelfLinkWithId()
  {
    return $this->selfLinkWithId;
  }
  /**
   * Output only. [Output Only] The status of storage pool creation.
   * - CREATING: Storage pool is provisioning.      storagePool.      - FAILED:
   * Storage pool creation failed.      - READY: Storage pool is ready for use.
   * - DELETING: Storage pool is deleting.
   *
   * Accepted values: CREATING, DELETING, FAILED, READY
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Output only. [Output Only] Status information for the storage pool
   * resource.
   *
   * @param StoragePoolResourceStatus $status
   */
  public function setStatus(StoragePoolResourceStatus $status)
  {
    $this->status = $status;
  }
  /**
   * @return StoragePoolResourceStatus
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * Type of the storage pool.
   *
   * @param string $storagePoolType
   */
  public function setStoragePoolType($storagePoolType)
  {
    $this->storagePoolType = $storagePoolType;
  }
  /**
   * @return string
   */
  public function getStoragePoolType()
  {
    return $this->storagePoolType;
  }
  /**
   * Output only. [Output Only] URL of the zone where the storage pool resides.
   * You must specify this field as part of the HTTP request URL. It is not
   * settable as a field in the request body.
   *
   * @param string $zone
   */
  public function setZone($zone)
  {
    $this->zone = $zone;
  }
  /**
   * @return string
   */
  public function getZone()
  {
    return $this->zone;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(StoragePool::class, 'Google_Service_Compute_StoragePool');
