<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1BatchPredictionJobInputConfig extends \Google\Model
{
  protected $bigquerySourceType = GoogleCloudAiplatformV1BigQuerySource::class;
  protected $bigquerySourceDataType = '';
  protected $gcsSourceType = GoogleCloudAiplatformV1GcsSource::class;
  protected $gcsSourceDataType = '';
  /**
   * Required. The format in which instances are given, must be one of the
   * Model's supported_input_storage_formats.
   *
   * @var string
   */
  public $instancesFormat;
  protected $vertexMultimodalDatasetSourceType = GoogleCloudAiplatformV1VertexMultimodalDatasetSource::class;
  protected $vertexMultimodalDatasetSourceDataType = '';

  /**
   * The BigQuery location of the input table. The schema of the table should be
   * in the format described by the given context OpenAPI Schema, if one is
   * provided. The table may contain additional columns that are not described
   * by the schema, and they will be ignored.
   *
   * @param GoogleCloudAiplatformV1BigQuerySource $bigquerySource
   */
  public function setBigquerySource(GoogleCloudAiplatformV1BigQuerySource $bigquerySource)
  {
    $this->bigquerySource = $bigquerySource;
  }
  /**
   * @return GoogleCloudAiplatformV1BigQuerySource
   */
  public function getBigquerySource()
  {
    return $this->bigquerySource;
  }
  /**
   * The Cloud Storage location for the input instances.
   *
   * @param GoogleCloudAiplatformV1GcsSource $gcsSource
   */
  public function setGcsSource(GoogleCloudAiplatformV1GcsSource $gcsSource)
  {
    $this->gcsSource = $gcsSource;
  }
  /**
   * @return GoogleCloudAiplatformV1GcsSource
   */
  public function getGcsSource()
  {
    return $this->gcsSource;
  }
  /**
   * Required. The format in which instances are given, must be one of the
   * Model's supported_input_storage_formats.
   *
   * @param string $instancesFormat
   */
  public function setInstancesFormat($instancesFormat)
  {
    $this->instancesFormat = $instancesFormat;
  }
  /**
   * @return string
   */
  public function getInstancesFormat()
  {
    return $this->instancesFormat;
  }
  /**
   * A Vertex Managed Dataset. Currently, only datasets of type Multimodal are
   * supported.
   *
   * @param GoogleCloudAiplatformV1VertexMultimodalDatasetSource $vertexMultimodalDatasetSource
   */
  public function setVertexMultimodalDatasetSource(GoogleCloudAiplatformV1VertexMultimodalDatasetSource $vertexMultimodalDatasetSource)
  {
    $this->vertexMultimodalDatasetSource = $vertexMultimodalDatasetSource;
  }
  /**
   * @return GoogleCloudAiplatformV1VertexMultimodalDatasetSource
   */
  public function getVertexMultimodalDatasetSource()
  {
    return $this->vertexMultimodalDatasetSource;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1BatchPredictionJobInputConfig::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1BatchPredictionJobInputConfig');
