@extends('layouts.admin.app')

@section('title', translate('deliveryman_report'))

@section('content')
    <div class="content container-fluid">
        <div class="mb-3">
            <h2 class="text-capitalize mb-0 d-flex align-items-center gap-2">
                <img width="20" src="{{asset('public/assets/admin/img/icons/deliveryman-new.png')}}" alt="{{ translate('deliveryman_report') }}">
                {{translate('deliveryman_report')}}
            </h2>
        </div>
        <div class="row g-2 mb-2">
            <div class="col-md-6 col-lg-4">
               <a href="javascript:" class="cursor-default">
                    <div class="badge-soft-info text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h5 class="font-weight-normal mb-1">{{translate('Currently Assign Deliveries')}}</h5>
                            <h2 class="fs-30 fs-20-mobile">{{ $totalCurrentlyAssignedDeliveries }}</h2>
                        </div>
                        <div class="btn btn-circle bg-white d-flex justify-content-center align-items-center" style="--size: 48px;">
                            <img width="20" src="{{asset('public/assets/admin/img/icons/assign-deliveries.png')}}" alt="{{ translate('deliveryman_report') }}">
                        </div>
                    </div>
               </a>
            </div>
            <div class="col-md-6 col-lg-4">
                <a href="javascript:" class="cursor-default">
                    <div class="badge-soft-success text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h5 class="font-weight-normal mb-1">{{translate('Completed Deliveries')}}</h5>
                            <h2 class="fs-30 fs-20-mobile">{{ $totalCompletedDeliveries }}</h2>
                        </div>
                        <div class="btn btn-circle bg-white d-flex justify-content-center align-items-center" style="--size: 48px;">
                            <img width="20" src="{{asset('public/assets/admin/img/icons/completed-deliveries.png')}}" alt="{{ translate('deliveryman_report') }}">
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-md-6 col-lg-4">
                <a href="javascript:" class="cursor-default">
                    <div class="bg-soft-info text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h5 class="font-weight-normal mb-1">{{translate('Out for Delivery')}}</h5>
                            <h2 class="fs-30 fs-20-mobile">{{ $totalOutForDelivery }}</h2>
                        </div>
                        <div class="btn btn-circle bg-white d-flex justify-content-center align-items-center" style="--size: 48px;">
                            <img width="20" src="{{asset('public/assets/admin/img/icons/out-for-delivery.png')}}" alt="{{ translate('deliveryman_report') }}">
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-md-6 col-lg-4">
                <a href="javascript:" class="cursor-default">
                    <div class="badge-soft-danger text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h5 class="font-weight-normal mb-1">{{translate('Canceled Deliveries')}}</h5>
                            <h2 class="fs-30 fs-20-mobile">{{ $totalCanceledDeliveries }}</h2>
                        </div>
                        <div class="btn btn-circle bg-white d-flex justify-content-center align-items-center" style="--size: 48px;">
                            <img width="20" src="{{asset('public/assets/admin/img/icons/canceled-deliveries.png')}}" alt="{{ translate('deliveryman_report') }}">
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-md-6 col-lg-4">
                <a href="javascript:" class="cursor-default">
                    <div class="badge-soft-primary text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h5 class="font-weight-normal mb-1">{{translate('Return Deliveries')}}</h5>
                            <h2 class="fs-30 fs-20-mobile">{{ $totalReturnedDeliveries }}</h2>
                        </div>
                        <div class="btn btn-circle bg-white d-flex justify-content-center align-items-center" style="--size: 48px;">
                            <img width="20" src="{{asset('public/assets/admin/img/icons/return-deliveries.png')}}" alt="{{ translate('deliveryman_report') }}">
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-md-6 col-lg-4">
                <a href="javascript:" class="cursor-default">
                    <div class="badge-soft-warning text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h5 class="font-weight-normal mb-1">{{translate('Failed Deliveries')}}</h5>
                            <h2 class="fs-30 fs-20-mobile">{{ $totalFailedDeliveries }}</h2>
                        </div>
                        <div class="btn btn-circle bg-white d-flex justify-content-center align-items-center" style="--size: 48px;">
                            <img width="20" src="{{asset('public/assets/admin/img/icons/failed-deliveries.png')}}" alt="{{ translate('deliveryman_report') }}">
                        </div>
                    </div>
                </a>
            </div>
        </div>

        <div class="card mb-3 pb-4">
            <div class="card-body">
                <div class="d-flex align-items-center gap-3 flex-wrap justify-content-between mb-xl-4 mb-3">
                    <h4 class="text-capitalize fs-18 mb-0">
                        {{ translate('Successful Delivery Rate') }}
                    </h4>
                    <div class="border rounded p-1 ">
                        <ul class="nav nav-pills border-0 gap-1">
                            <li class="nav-item m-0">
                                <a href="javascript:" class="nav-link font-weight-bold text--primary px-3 py-2 active" data-bar-chart-date-criteria="today">Today</a>
                            </li>
                            <li class="nav-item m-0">
                                <a href="javascript:" class="nav-link font-weight-bold text--primary px-3 py-2" data-bar-chart-date-criteria="this_week">This Week</a>
                            </li>
                             <li class="nav-item m-0">
                                <a href="javascript:" class="nav-link font-weight-bold text--primary px-3 py-2" data-bar-chart-date-criteria="this_month">This Month</a>
                            </li>
                             <li class="nav-item m-0">
                                <a href="javascript:" class="nav-link font-weight-bold text--primary px-3 py-2" data-bar-chart-date-criteria="this_year">This Year</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="chart-container-custom">
                    <div id="myChart-custom"></div>
                </div>
            </div>
        </div>

        <div class="row g-2">
            <div class="col-lg-6">
                <div class="card card-body p-0 h-100">
                    <div class="p-3">
                        <h5 class="text-capitalize">
                            {{ translate('Deliveryman Availability Status') }}
                        </h5>
                        <p class="text-dark mb-2">{{ translate('Total Deliverymen') }}: <strong>{{ $totalDeliveryMen }}</strong></p>
                    </div>
                    <div class="d-flex justify-content-center align-items-end h-100">
                        <div class="w-100">
                            <div class="chartjs-custom position-relative w-100 h-250 h-180-mobile">
                                <canvas id="deliveryman-availability-overview"></canvas>
                            </div>
                            <div id="availabilityLegend" class="border-top mt-5 p-3 d-flex justify-content-between justify-content-sm-around align-items-center flex-wrap gap-4 overflow-wrap-anywhere"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="bg-light border rounded p-3 overflow-wrap-anywhere h-100">
                    <div class="d-flex justify-content-between align-items-center gap-3 mb-4">
                        <div class="text-capitalize mb-0 d-flex align-items-center gap-2">
                            <img width="16" src="{{asset('public/assets/admin/img/icons/top-delieveryman.png')}}" alt="{{ translate('deliveryman_report') }}">
                            <h5 class="mb-1">{{translate('Top Delivery Man')}}</h5>
                        </div>
                        <a href="{{ route('admin.delivery-man.list') }}" class="text-primary font-weight-bold">{{ translate('View_All') }}</a>
                    </div>
                    <div class="row g-2">
                        @foreach($topDeliveryMen as $key => $deliveryMan)
                            <div class="col-sm-6 col-lg-4">
                                <div class="bg-white rounded shadow-sm h-100 overflow-hidden d-flex flex-column">
                                    <div class="p-3 py-sm-4 d-flex justify-content-center align-items-center">
                                        <div class="avatar-70 border rounded-circle">
                                            <img class="rounded-circle img-fit" src="{{ $deliveryMan->image_fullpath }}" alt="">
                                        </div>
                                    </div>
                                    <div class="p-2 bg-light text-dark text-center d-flex flex-column justify-content-between h-100">
                                        <a href="{{ route('admin.delivery-man.details', $deliveryMan->id)}}"
                                            class="mb-1 text-dark line--limit-1" data-toggle="tooltip" data-title="{{ $deliveryMan->f_name . ' ' . $deliveryMan->l_name }}">
                                            {{ $deliveryMan->f_name . ' ' . $deliveryMan->l_name }}
                                        </a>
                                        <div>
                                            <div class="">
                                                <span>{{ translate('Order Delivered') }} : </span>
                                                <strong class="text-link">{{ $deliveryMan->getOrdersCompleted->count() }}</strong>
                                            </div>
                                            <div class="">
                                                <span>{{ translate('Currently Assign') }} : </span>
                                                <strong class="text-success">{{ $deliveryMan->getOrdersOnDelivery->count() }}</strong>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script src="{{asset('public/assets/admin/vendor/chart.js/dist/Chart.min.js')}}"></script>
    <script src="{{asset('public/assets/admin/vendor/chart.js.extensions/chartjs-extensions.js')}}"></script>
    <script src="{{asset('public/assets/admin/vendor/chartjs-plugin-datalabels/dist/chartjs-plugin-datalabels.min.js')}}"></script>
    <script src="{{asset('public/assets/admin/vendor/apexchart/apexChart.js')}}"></script>


@endpush


@push('script_2')
    <script>
        'use strict';

        document.addEventListener("DOMContentLoaded", function () {
            let ctx = document.getElementById('deliveryman-availability-overview');
            let legendContainer = document.getElementById('availabilityLegend');
            let driverAvailabilityStatus = @json($driverAvailabilityStatus);

            let engaged = Number(driverAvailabilityStatus.engaged) || 0;
            let available = Number(driverAvailabilityStatus.available) || 0;
            let inactive = Number(driverAvailabilityStatus.inactive) || 0;

            let totalDrivers = engaged + available + inactive;

            if (totalDrivers === 0) {

                legendContainer.innerHTML = '';

                ctx.parentElement.innerHTML = `
                    <div class="text-dark p-3 h-100 d-flex justify-content-center align-items-center flex-column text-center">
                        <h4 class="fs-16 mb-1">
                            {{translate("No Deliveryman Available")}}
                        </h4>
                        <div>
                            {{translate("Deliveryman availability data will appear here.")}}
                        </div>
                    </div>
                `;

                return;
            }
            let myChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: [
                        '{{translate("Engaged")}}',
                        '{{translate("Available")}}',
                        '{{translate("Inactive")}}',
                    ],
                    datasets: [{
                        data: [engaged, available, inactive],
                        backgroundColor: ['#10B981', '#3B82F6', '#F67C3B'],
                        borderWidth: 0,
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutoutPercentage: 70,

                    layout: {
                        padding: {
                            top: 30,
                            right: 20,
                            bottom: 20,
                            left: 20,
                        }
                    },

                    legend: {
                        display: false,
                    },

                    plugins: {
                        datalabels: {
                            clip: false,

                            color: function (context) {
                                return context.dataset.backgroundColor[context.dataIndex];
                            },

                            font: {
                                weight: '500',
                                size: 12
                            },

                            anchor: 'end',
                            align: 'end',
                            offset: 0,

                            formatter: function (value, context) {
                                let data = context.chart.data.datasets[0].data;
                                let total = data.reduce((a, b) => a + b, 0);

                                if (total === 0) {
                                    return context.chart.data.labels[context.dataIndex] + ' 0%';
                                }

                                let percentage = ((value / total) * 100).toFixed(0);

                                return context.chart.data.labels[context.dataIndex] + ' ' + percentage + '%';
                            }
                        }
                    }
                }

            });

            function generateLegend(chart) {
                let legendContainer = document.getElementById('availabilityLegend');
                legendContainer.innerHTML = '';

                chart.data.labels.forEach(function(label, i) {
                    let value = chart.data.datasets[0].data[i];
                    let color = chart.data.datasets[0].backgroundColor[i];

                    let item = document.createElement('div');
                    item.classList.add('availability-legend-item');

                    item.onclick = function() {
                        let meta = chart.getDatasetMeta(0);
                        meta.data[i].hidden = !meta.data[i].hidden;
                        chart.update();
                    };

                    item.innerHTML = `
                        <span style="
                            width:12px;
                            height:12px;
                            background:${color};
                            border-radius:50%;
                            display:inline-block;
                        "></span>

                        <div class="text-dark">
                            <div class="mb-2">
                                ${label}
                            </div>
                            <div class="font-weight-bold fs-24 fs-18-mobile">
                                ${value}
                            </div>
                        </div>
                    `;

                    legendContainer.appendChild(item);
                });
            }

            generateLegend(myChart);
        });

    </script>
    <script>
        let deliveryChart;

        $(document).on('click', '[data-bar-chart-date-criteria]', function () {
            $('[data-bar-chart-date-criteria]').removeClass('active');
            $(this).addClass('active');
            let criteria = $(this).data('bar-chart-date-criteria');
            loadDeliveryRate(criteria);
        });

        document.addEventListener("DOMContentLoaded", function () {
            const el = document.querySelector("#myChart-custom");
            if (!el) return;

            deliveryChart = new ApexCharts(el, {
                series: [
                    { name: "Completed", data: [] },
                    { name: "Canceled, Failed and Return", data: [] }
                ],

                chart: {
                    type: "bar",
                    height: 320,
                    toolbar: { show: false }
                },

                plotOptions: {
                    bar: {
                        columnWidth: "15%",
                        borderRadius: 2,
                        borderRadiusApplication: "end"
                    }
                },

                colors: ["#019463", "#F4891E"],

                dataLabels: { enabled: false },

                legend: {
                    position: "top",
                    markers: { radius: 6 }
                },

                xaxis: {
                    categories: []
                },

                yaxis: {
                    min: 0,
                    max: 100,
                    tickAmount: 4,
                    labels: {
                        formatter: val => val + "%"
                    }
                },

                grid: {
                    borderColor: "#E9EDF3",
                    strokeDashArray: 4
                },

                tooltip: {
                    theme: "dark"
                }
            });

            deliveryChart.render();
        });

        loadDeliveryRate('today');
        function loadDeliveryRate(criteria) {
            $.ajax({
                url: "{{ route('admin.report.get-successful-delivery-rate-data') }}",
                method: "GET",
                data: {
                    date_criteria: criteria
                },
                success: function (res) {

                    const barWidth = 40;
                    const minChartWidth = res.labels.length * barWidth;

                    const containerWidth = document.querySelector('.chart-container-custom').offsetWidth;
                    const chartWidth = Math.max(minChartWidth, containerWidth);


                    deliveryChart.updateOptions({
                        chart: { width: chartWidth },
                        xaxis: { categories: res.labels }
                    });

                    deliveryChart.updateSeries([
                        {
                            name: "Completed",
                            data: res.completedOrdersPercentage
                        },
                        {
                            name: "Canceled, Failed and Return",
                            data: res.failedCanceledReturnedOrdersPercentage
                        }
                    ]);
                }
            });
        }
    </script>
@endpush
