@if(count($combinations) > 0)
    <table class="table table-bordered">
        <thead>
        <tr>
            <td class="text-center">
                <label for="" class="control-label">Variant</label>
            </td>
            <td class="text-center">
                <label for="" class="control-label">Variant Price</label>
            </td>
            <td class="text-center">
                <label for="" class="control-label">Variant Stock</label>
            </td>
        </tr>
        </thead>
        <tbody>

        @foreach ($combinations as $key => $combination)
            <tr>
                <td>
                    <label for="" class="control-label">{{ $combination['type'] }}</label>
                </td>
                <td>
                    <input type="number" name="price_{{ $combination['type'] }}"
                           value="{{$combination['price']}}" min="0.01"
                           step="0.01"
                           class="form-control" >
                    <span class="error-text" data-error="price_{{ $combination['type'] }}"></span>
                </td>
                <td>
                    <input type="number" name="stock_{{ $combination['type'] }}" value="{{ $combination['stock']??0 }}"
                           min="0" max="1000000"
                           class="form-control" onkeyup="update_qty()" >
                    <span class="error-text" data-error="stock_{{ $combination['type'] }}"></span>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
@endif
