@forelse($customerList as $customer)
    @if($customer->user)
        <div
            class="sidebar_primary_div media gap-12px p-12px mb-10px align-items-center customer-list cursor-pointer view-conversation-message rounded {{ $customer->total_unread_message != 0 ? 'conv-active' : '' }}"
            data-route="{{route('admin.message.view',[$customer->user_id])}}"
            data-id="{{ $customer->user_id }}"
        >
            <div class="avatar avatar-50 rounded-circle">
                <img class="img-fit rounded-circle"
                     src="{{$customer->user['image_fullpath']}}"
                     alt="{{ translate('image') }}">
            </div>
            <h5 class="sidebar_name mb-0 d-flex gap-2 justify-content-between align-items-center flex-grow-1">
                <div>
                    <div>{{ $customer->user['f_name'].' '.$customer->user['l_name'] }}</div>
                    <a class="text-dark fs-12 font-weight-normal"
                       href="tel:{{ $customer->user['phone'] }}">{{ $customer->user['phone'] }}</a>
                </div>
                <span class="{{ $customer->total_unread_message != 0 ? 'badge badge-soft-info badge-pill' : '' }}"
                      id="counter-{{ $customer->user_id }}">{{ $customer->total_unread_message != 0 ? $customer->total_unread_message : ''}}</span>
            </h5>
        </div>
    @endif
@empty
    <div class="error-boxes w-100 h-100 pb-10 d-center text-center">
        <div class="pb-10 mb-4">
            <img width="49" src="{{asset('public/assets/admin/img/no-customer-found.svg')}}"
                 alt="{{ translate('message') }}" class="mb-10px">
            <p class="fs-14 m-0 text-dark">{{translate('No Customer Found')}}</p>
        </div>
    </div>
@endforelse
