@php
 use Carbon\Carbon;
 $order = $orders->first();
@endphp
@extends('layouts.admin.app')
@section('title', translate('Deliveryman Details'))

@section('content')
    <div class="content container-fluid">
        <h4 class="text-capitalize mb-3 d-flex align-items-center gap-2">
            <img width="20" src="{{asset('public/assets/admin/img/icons/deliveryman-new.png')}}"
                 alt="{{ translate('deliveryman') }}">
            {{translate('Deliveryman_Details')}}
        </h4>

        <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">{{ translate('Profile Details') }}</h5>
                <a href="{{ route('admin.delivery-man.edit', $deliveryMan->id) }}" class="btn btn-primary px-4 d-flex gap-2 align-items-center"><i
                        class="tio-edit fs-14"></i> {{ translate('Edit') }}</a>
            </div>
            <div class="card-body text-dark">
                <div class="row g-3">
                    <div class="col-sm-6 col-xxl-3">
                        <div class="d-flex align-items-center gap-2">
                            <div class="avatar-70 aspect-1 border rounded-circle">
                                <img class="rounded-circle img-fit"
                                     src="{{ $deliveryMan->image_fullpath }}" alt="">
                            </div>
                            <div>
                                <h2 class="fs-18-mobile mb-1">{{ $deliveryMan->f_name . ' ' . $deliveryMan->l_name }}</h2>
                                <p class="fs-12-mobile mb-0">{{ translate('Joining date :') }} {{ Carbon::parse($deliveryMan->approved_at)->format('d M, Y') }}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-xxl-3">
                        <div class="d-flex gap-4 h-100">
                            <div class="border-inline-start h-100 d-none d-sm-block"></div>
                            <div>
                                <h4 class="mb-2 opacity-lg">{{ translate('Contact info') }}</h4>
                                <div class="d-flex flex-column gap-2">
                                    <p class="fs-12-mobile mb-0">{{ $deliveryMan->email }}</p>
                                    <p class="fs-12-mobile mb-0">{{ $deliveryMan->phone }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xxl-6">
                        <div class="d-flex gap-4 h-100 position-relative  overflow-slider-wrapper">
                            <div class="border-inline-start h-100 d-none d-xl-block"></div>
                            <div class="flex-shrink-0">
                                <h4 class="mb-2 opacity-lg">{{ translate('Identity info') }}</h4>
                                <div class="d-flex flex-column gap-2">
                                    <p class="fs-12-mobile mb-0">
                                        <span>{{ translate('Identity Type') }}</span>
                                        <span class="px-2">:</span>
                                        <span>{{ $deliveryMan->identity_type }}</span>
                                    </p>
                                    <p class="fs-12-mobile mb-0">
                                        <span>{{ translate('Identity Number') }}</span>
                                        <span class="px-2">:</span>
                                        <span>{{ $deliveryMan->identity_number }}</span>
                                    </p>
                                </div>
                            </div>
                            @if(count($deliveryMan->identity_image_fullpath ?? []) > 0)
                                <div
                                    class="flex-grow-1 d-flex {{ count($deliveryMan->identity_image_fullpath ?? []) == 1 ? 'justify-content-end' : '' }} gap-2 overflow-x-auto overflow-slider">
                                    @foreach($deliveryMan->identity_image_fullpath as $img)
                                        <div
                                            class="slide w-200px h-100px border rounded-lg overflow-hidden flex-shrink-0">
                                            <img class="img-fit" src="{{ $img }}" alt="{{ translate('image') }}">
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                            @if(count($deliveryMan->identity_image_fullpath ?? []) > 1)
                                <div class="slider-button-middle">
                                    <button type="button"
                                            class="slider_prev_btn prev-btn d--none btn btn-primary btn-circle">
                                        <div class="d-flex align-items-center justify-content-center">
                                            <i class="tio-chevron-left fs-16"></i>
                                        </div>
                                    </button>
                                    <button type="button"
                                            class="slider_next_btn next-btn d--none btn btn-primary btn-circle">
                                        <div class="d-flex align-items-center justify-content-center">
                                            <i class="tio-chevron-right fs-16"></i>
                                        </div>
                                    </button>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card card-body mb-3">
            <form action="">
                <div class="row g-2 align-items-end">
                    <div class="col-md-6 col-lg-4">
                        <div>
                            <label class="input-label" for="">{{ translate('Order Date') }}</label>
                            <div class="position-relative">
                                <i class="tio-calendar icon-absolute-on-right"></i>
                                <input type="text" name="order_date" value="{{ request()->get('order_date') }}"
                                       class="form-control js-daterangepicker-formatted"
                                       placeholder="{{ translate('Select Date') }}">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div>
                            <label class="input-label" for="">{{ translate('Branch') }}</label>
                            <select name="branch_id" id="" class="form-control custom-select">
                                <option value="all" selected>{{ translate('All Branch') }}</option>
                                @foreach($branches as $branch)
                                    <option
                                        value="{{ $branch->id }}" {{ $branch->id == request()->get('branch_id') ? 'selected' : '' }}>{{ $branch->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <input type="hidden" name="search" value="{{ request()->get('search') }}">
                    <div class="col-12 col-lg-4">
                        <div class="d-flex justify-content-end align-items-center gap-2 mt-2">
                            <a href="{{ route('admin.delivery-man.details', $deliveryMan->id) }}" class="btn min-w-120 btn-secondary">{{ translate('Reset') }}</a>
                            <button type="submit" class="btn min-w-120 btn-primary">{{ translate('Filter') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="auto-col gap-2 mb-3 px-3" style="--minWidth: 210px">

            <div class="">
                <a href="javascript:">
                    <div
                        class="badge-soft-success text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h3 class="fs-16-mobile mb-1">{{ $deliveryMan?->orders->where('order_status', 'delivered')->count() }}</h3>
                            <h5 class="mb-0">{{translate('Completed')}}</h5>
                        </div>
                        <div>
                            <img width="30" class="img-fluid aspect-1"
                                 src="{{asset('public/assets/admin/img/icons/completed.png')}}"
                                 alt="{{ translate('Completed') }}">
                        </div>
                    </div>
                </a>
            </div>

            <div class="">
                <a href="javascript:">
                    <div
                        class="badge-soft-danger text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h3 class="fs-16-mobile mb-1">{{ $deliveryMan?->orders->where('order_status', 'failed')->count() }}</h3>
                            <h5 class="mb-0">{{translate('Failed')}}</h5>
                        </div>
                        <div>
                            <img width="30" class="img-fluid aspect-1"
                                 src="{{asset('public/assets/admin/img/icons/failed.png')}}"
                                 alt="{{ translate('Failed') }}">
                        </div>
                    </div>
                </a>
            </div>

            <div class="">
                <a href="javascript:">
                    <div
                        class="badge-soft-primary text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h3 class="fs-16-mobile mb-1">{{ $deliveryMan?->orders->where('order_status', 'out_for_delivery')->count() }}</h3>
                            <h5 class="mb-0">{{translate('Out for Delivery')}}</h5>
                        </div>
                        <div>
                            <img width="30" class="img-fluid aspect-1"
                                 src="{{asset('public/assets/admin/img/icons/out-for-delivery-new.png')}}"
                                 alt="{{ translate('Out for Delivery') }}">
                        </div>
                    </div>
                </a>
            </div>

            <div class="">
                <a href="javascript:">
                    <div
                        class="badge-soft-success text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h3 class="fs-16-mobile mb-1">{{ Helpers::set_symbol($deliveryMan?->orders->where('order_status', 'delivered')->sum('order_amount')) }}</h3>
                            <h5 class="mb-0">{{translate('Order Amount')}}</h5>
                        </div>
                        <div>
                            <img width="30" class="img-fluid aspect-1"
                                 src="{{asset('public/assets/admin/img/icons/order-amount.png')}}"
                                 alt="{{ translate('Order Amount') }}">
                        </div>
                    </div>
                </a>
            </div>

            <div class="">
                <a href="javascript:">
                    <div
                        class="badge-soft-info text-dark border rounded-lg p-3 p-lg-4 d-flex justify-content-between gap-2 overflow-wrap-anywhere h-100">
                        <div>
                            <h3 class="fs-16-mobile mb-1">{{  $deliveryMan?->orders->count() > 0 ? number_format(100 * $deliveryMan?->orders->where('order_status', 'delivered')->count() / $deliveryMan?->orders->count(), 2) : 0 }}%</h3>
                            <h5 class="mb-0">{{translate('Success Rate')}}</h5>
                        </div>
                        <div>
                            <img width="30" class="img-fluid aspect-1"
                                 src="{{asset('public/assets/admin/img/icons/success-rate.png')}}"
                                 alt="{{ translate('Success Rate') }}">
                        </div>
                    </div>
                </a>
            </div>

        </div>

        <div class="card">

            <div class="p-3">
                <div class="d-flex flex-wrap justify-content-between align-items-center gap-3">
                    <div class="d-flex flex-wrap gap-2 align-items-center">
                        <h5 class="text-capitalize mb-0">
                            {{translate('Order List')}}
                        </h5>
                        <span class="badge badge-soft-dark rounded-50 fs-14">{{ $orders->total() }}</span>
                    </div>
                    <div class="d-flex flex-wrap align-items-center gap-3 flex-grow-1 justify-content-md-end">
                        <form action="{{ request()->url() }}" method="GET" class="flex-grow-1 max-w-270">
                            <div class="input-group min-h-35 w-100">
                                <input id="datatableSearch_" type="search" name="search"
                                       class="form-control py-1 h-35 fs-12"
                                       placeholder="{{translate('Search by order id/Branch name')}}" aria-label="Search"
                                       value="{{ request()->get('search') }}" autocomplete="off">
                                @foreach (request()->except('search','page') as $key => $value)
                                    <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                                @endforeach
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary px-2 py-1 min-h-35">
                                        <i class="tio-search"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                        <div>
                            <button type="button"
                                    class="btn btn-outline-primary gap-1 d-flex font-weight-bold align-items-center min-h-35 py-1 fs-12 cmn-border"
                                    data-toggle="dropdown" aria-expanded="false">
                                <i class="tio-download-to"></i>{{ translate('export') }}<i class="tio-chevron-down"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-right w-auto">
                                <li>
                                    <a class="dropdown-item d-flex align-items-center gap-2"
                                       href="{{ route('admin.delivery-man.export-details', array_merge(['id' => $deliveryMan->id],request()->query())) }}">
                                    <img width="14" src="{{asset('public/assets/admin/img/icons/excel.png')}}"
                                             alt="{{ translate('excel') }}">
                                        {{translate('excel')}}
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-responsive datatable-custom">
                <table
                    class="table table-border table-thead-bordered table-nowrap table-align-middle card-table text-dark">
                    <thead class="thead-light">
                    <tr>
                        <th>{{translate('SL')}}</th>
                        <th>{{translate('Order ID')}}</th>
                        <th>{{translate('Total Items')}}</th>
                        <th>{{translate('Payment Method')}}</th>
                        <th class="text-center">{{translate('Branch')}}</th>
                        <th class="text-center">{{translate('Order Status')}}</th>
                        <th class="text-center">{{translate('action')}}</th>
                    </tr>
                    </thead>

                    <tbody id="set-rows">
                    @foreach($orders as $key => $order)
                        <tr>
                            <td>{{ $orders->firstitem() + $key }}</td>
                            <td>{{ $order->id }}</td>
                            <td>{{ $order->details->count() }}</td>
                            <td class="text-center">{{ $order->payment_method == 'multiple' ? implode(', ', $order->additional_payment_method ?? ["N/A"]) : translate($order->payment_method) }}</td>
                            <td>
                                <div class="d-flex justify-content-center align-items-center">
                                    <span
                                        class="fs-12 px-2 badge badge-soft-secondary">{{ $order->branch?->name ?? translate('Branch Deleted') }}</span>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex justify-content-center align-items-center">
                                    <span class="fs-12 px-2 badge badge-soft-danger">{{ $order->order_status }}</span>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex justify-content-center align-items-center gap-10">
                                    <a class="btn btn-outline-primary square-btn"
                                       href="{{ route('admin.orders.details', $order->id) }}">
                                        <i class="tio-visible"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

            <div class="">
                {!! $orders->links('layouts/partials/_pagination', ['perPage' => (int) ($request->per_page ?? Helpers::pagination_limit())]) !!}
            </div>
            @if(count($orders)==0)
                <div class="text-center p-4">
                    <img class="mb-3 width-7rem" src="{{asset('public/assets/admin//svg/illustrations/sorry.svg')}}"
                         alt="{{ translate('image') }}">
                    <p class="mb-0">{{ translate('No data to show') }}</p>
                </div>
            @endif
        </div>
    </div>

@endsection

@push('script_2')
    <script>
        'use strict';

        function initOverflowSliders() {

            $(document).find('.overflow-slider-wrapper').each(function () {

                const wrapper = $(this);

                if (wrapper.data('overflow-init')) return;
                wrapper.data('overflow-init', true);

                const slider = wrapper.find('.overflow-slider');
                const prevBtn = wrapper.find('.slider_prev_btn');
                const nextBtn = wrapper.find('.slider_next_btn');

                const isRTL = $('html').attr('dir') === 'rtl';

                function updateButtons() {
                    const scrollLeft = Math.abs(slider[0].scrollLeft);
                    const maxScroll = slider[0].scrollWidth - slider.outerWidth();

                    if (slider[0].scrollWidth <= slider.outerWidth()) {
                        prevBtn.addClass('d--none');
                        nextBtn.addClass('d--none');
                        return;
                    }

                    // Prev
                    scrollLeft <= 0
                        ? prevBtn.addClass('d--none')
                        : prevBtn.removeClass('d--none');

                    // Next
                    scrollLeft >= maxScroll - 1
                        ? nextBtn.addClass('d--none')
                        : nextBtn.removeClass('d--none');
                }

                prevBtn.on('click', function () {
                    slider.animate({
                        scrollLeft: isRTL
                            ? slider[0].scrollLeft + 220
                            : slider[0].scrollLeft - 220
                    }, 500);
                });

                nextBtn.on('click', function () {
                    slider.animate({
                        scrollLeft: isRTL
                            ? slider[0].scrollLeft - 220
                            : slider[0].scrollLeft + 220
                    }, 500);
                });

                slider.on('scroll', updateButtons);
                $(window).on('resize', updateButtons);

                updateButtons();
            });
        }

        $(function () {
            initOverflowSliders();
        });
    </script>

@endpush
