@extends('layouts.admin.app')

@section('title', translate('Firebase Settings'))

@section('content')
    <div class="content container-fluid">
        <div class="mb-4">
            <h2 class="text-capitalize mb-0 d-flex align-items-center gap-2">
                <img width="20" src="{{asset('public/assets/admin/img/icons/firebase.png')}}" alt="{{ translate('firebase_image') }}">
                {{translate('Firebase_Push_Notification_setup')}}
            </h2>
        </div>

        <div class="inline-page-menu my-4">
            @include('admin-views.business-settings.partial.third-party-nav')
        </div>

        <div class="inline-page-menu my-4 d-flex flex-wrap justify-content-between gap-3 w-100">
            @include('admin-views.business-settings.partial.firebase-setup-nav')
            <a href="#firebase-modal" data-toggle="modal" class="text-primary d-flex align-items-center gap-2">
                <strong>{{translate('Where to get this information')}}</strong>
                <i class="tio-info"></i>
            </a>
        </div>

        <div class="card">
            @php($data=Helpers::get_business_settings('firebase_message_config'))
            <div class="card-body">
                <form action="{{env('APP_MODE')!='demo'?route('admin.business-settings.firebase_message_config'):'javascript:'}}" method="post" enctype="multipart/form-data">
                    @csrf
                    @if(isset($data))
                    <div class="row">
                        <div class="col-12">
                             @php($serviceFileContent = Helpers::get_business_settings('push_notification_service_file_content'))
                            <div class="form-group">
                                <label class="input-label">{{translate('service_file_content')}}
                                    <span class="input-label-secondary text-danger">*</span>
                                    <i class="tio-info cursor-pointer text-black-50" data-toggle="tooltip" data-placement="top"
                                    title="{{ translate('select and copy all the service file content and add here') }}">
                                    </i>
                                </label>
                                <textarea name="push_notification_service_file_content" class="form-control" rows="15"
                                        required>{{env('APP_MODE')!='demo'?json_encode($serviceFileContent):''}}</textarea>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label>{{translate('API Key')}}</label>
                                <span class="input-label-secondary text-danger">*</span>
                                <input type="text" placeholder="{{translate('Ex : API Key')}}" class="form-control" name="apiKey"
                                       value="{{env('APP_MODE')!='demo'?$data['apiKey']:''}}" required autocomplete="off">
                            </div>
                        </div>
                        <div class="col-xl-4 col-sm-6">
                            <div class="form-group">
                                <label>{{translate('Project ID')}}</label>
                                <span class="input-label-secondary text-danger">*</span>
                                <input type="text" placeholder="{{translate('Ex : my-awesome-app-12345')}}" class="form-control" name="projectId" value="{{env('APP_MODE')!='demo'?$data['projectId']:''}}" required autocomplete="off">
                            </div>
                        </div>
                        <div class="col-xl-4 col-sm-6">
                            <div class="form-group">
                                <label>{{translate('Auth Domain')}}</label>
                                <span class="input-label-secondary text-danger">*</span>
                                <input type="text" placeholder="{{ translate('Ex : my-awesome-app-firebaseapp.com') }}" class="form-control" name="authDomain" value="{{env('APP_MODE')!='demo'?$data['authDomain']:''}}" required autocomplete="off">
                            </div>
                        </div>
                        <div class="col-xl-4 col-sm-6">
                            <div class="form-group">
                                <label>{{translate('Storage Bucket')}}</label>
                                <span class="input-label-secondary text-danger">*</span>
                                <input type="text" placeholder="{{ translate('Ex : my-awesome-app-appspot.com') }}" class="form-control" name="storageBucket" value="{{env('APP_MODE')!='demo'?$data['storageBucket']:''}}" required autocomplete="off">
                            </div>
                        </div>
                        <div class="col-xl-4 col-sm-6">
                            <div class="form-group">
                                <label>{{translate('Messaging Sender ID')}}</label>
                                <span class="input-label-secondary text-danger">*</span>
                                <input type="text" placeholder="{{ translate('Ex : 1234567890') }}" class="form-control" name="messagingSenderId"
                                       value="{{env('APP_MODE')!='demo'?$data['messagingSenderId']:''}}" required autocomplete="off">
                            </div>
                        </div>
                        <div class="col-xl-4 col-sm-6">
                            <div class="form-group">
                                <label>{{translate('App ID')}}</label>
                                <span class="input-label-secondary text-danger">*</span>
                                <input type="text" placeholder="{{ translate('Ex : 1234567890') }}" class="form-control" name="appId"
                                       value="{{env('APP_MODE')!='demo'?$data['appId']:''}}" required autocomplete="off">
                            </div>
                        </div>
                        <div class="col-xl-4 col-sm-6">
                            <div class="form-group">
                                <label>{{translate('Measurement ID')}}</label>
                                <input type="text" placeholder="{{ translate('Ex : F-12345678') }}" class="form-control" name="measurement_id"
                                       value="{{ env('APP_MODE')!='demo' ? $data['measurement_id'] ?? null : '' }}"  autocomplete="off">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="d-flex justify-content-end">
                                <button type="{{env('APP_MODE')!='demo'?'submit':'button'}}"
                                        class="btn btn-primary demo-form-submit px-5">{{translate('Submit')}}
                                </button>
                            </div>
                            @else
                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary px-5">{{translate('configure')}}</button>
                                </div>
                            @endif
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="firebase-modal">
        <div class="modal-dialog status-warning-modal modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header p-2">
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true" class="tio-clear"></span>
                    </button>
                </div>
                <div class="modal-body pb-5 pt-0">
                    <div class="max-349 mx-auto mb-20">
                        <div class="text-center">
                            <img src="{{asset('/public/assets/admin/img/info.png')}}" alt="" class="mb-20">
                            <h5 class="modal-title">{{translate('Please_Visit_the_Docs_to_Set_FCM_on_Mobile_Apps')}}</h5>
                        </div>
                        <div class="text-center">
                            <p>
                                {{translate('Please_check_the_documentation_below_for_detailed_instructions_on_setting_up_your_mobile_app_to_receive_Firebase_Cloud_Messaging_(FCM)_notifications.')}}
                            </p>
                            <a href="https://6amtech.com/hexacom/documentation/admin-panel-mandatory-setup/#firebase-configuration-for-notification" target="_blank" class="font-weight-bold">{{translate('Click Here')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

