"use strict";
let selectedImages = [];
let selectedMedia = [];

$(document).ready(() => {
    $(document).off('change', '#select-media').on('change', '#select-media', function() {

        const MAX_UPLOAD = 4;
        const errorBox = $(".image-array").closest(".multiple-image-upload-error");
        const files = Array.from(this.files);
        let availableSlots = MAX_UPLOAD - selectedImages.length;
        const imageFiles = files.filter(file => file.type.startsWith('image/'));

        if (imageFiles.length !== files.length) {
            errorBox.find(".text-danger")
                .text("Only image files are allowed.")
                .removeClass("d-none")
                .addClass("d-block");
            this.value = null;
            return;
        }

        if (imageFiles.length > availableSlots) {
            errorBox.find(".text-danger")
                .removeClass("d-none")
                .addClass("d-block");
        } else {
            errorBox.find(".text-danger")
                .removeClass("d-block")
                .addClass("d-none");
        }

        imageFiles.slice(0, availableSlots).forEach(file => {
            selectedImages.push(file);
        });

        displaySelectedImages();
        this.value = null;
    });

    $(document).on("click", ".img-clear", function () {

        const errorBox = $(".image-array").closest(".multiple-image-upload-error");
        const index = $(this).closest(".upload_img_box").data("index");

        selectedImages.splice(index, 1);

        if (selectedImages.length < 4) {
            errorBox.find(".text-danger").removeClass("d-block").addClass("d-none");
        }

        displaySelectedImages();
    });


    function displaySelectedImages() {

        const containerImage = document.getElementById("selected-media-container");
        const imageArray = $(".image-array");

        containerImage.innerHTML = "";
        imageArray.empty();

        selectedImages.forEach((file, index) => {

            const input = document.createElement("input");
            input.type = "file";
            input.name = `images[${index}]`;
            input.classList.add(`image-index${index}`);
            input.hidden = true;

            const dt = new DataTransfer();
            dt.items.add(file);
            input.files = dt.files;

            containerImage.appendChild(input);

            const reader = new FileReader();

            reader.onload = function(e) {

                const $uploadDiv = $(`
                    <div class="upload_img_box mt-2 mb-2" data-index="${index}">
                        <span class="img-clear"><i class="tio-clear fs-12"></i></span>
                        <img src="${e.target.result}" alt="">
                    </div>
                `);

                imageArray.append($uploadDiv);
            };

            reader.readAsDataURL(file);
        });
    }

});

// add active class and remove
const targetNode = document.querySelector('.image-previw-multiple-here');
const checkAndToggleClass = () => {
    if (targetNode) {
        if (targetNode.querySelector('.upload_img_box')) {
            targetNode.classList.add('active');
        } else {
            targetNode.classList.remove('active');
        }
    }
};
checkAndToggleClass();
const observer = new MutationObserver(() => {
    checkAndToggleClass();
});
if (targetNode) {
    observer.observe(targetNode, { childList: true, subtree: true });
}
