let searchDebounceTimer;
let conversationDataToJs = $('#conversation-data-to-js');

$(document).off('keyup', '#search-conversation-user').on('keyup', '#search-conversation-user', function () {
    clearTimeout(searchDebounceTimer);
    searchDebounceTimer = setTimeout(() => {
        getCustomerList();
    }, 400);
});

$(document).off('click', '.view-conversation-message').on('click', '.view-conversation-message', function () {
    if ($(this).hasClass('conv-active'))
    {
        $(this).removeClass('conv-active');
        $('#counter-' + $(this).data('id')).remove();
    }
    $(this).siblings().removeClass('bg-section3');
    $(this).addClass('bg-section3');

    let userId = $(this).data('id');
    let route = $(this).data('route');
    viewConversation(userId, route);
    singleFileDownload();
    downloadZip();
});

$(document).off('click', '#reply-conversation-message').on('click', '#reply-conversation-message', function () {
    let route = $(this).data('route');
    replyConversation(route);
    singleFileDownload();
    downloadZip();
});

function getCustomerList() {
    let search = $('#search-conversation-user').val();
    $.ajax({
        url: conversationDataToJs.data('get-customer-list-route'),
        method: 'GET',
        data: {
            search
        },
        success: function (data) {
            $('.customer-list-wrap').empty().html(data.view);
        },
        error: function () {
            toastr.error(conversationDataToJs.data('on-error-global-message'), {
                CloseButton: true,
                ProgressBar: true
            });
        }
    })
}

function viewConversation(userId, route) {
    $.ajax({
        url: route,
        method: 'GET',
        data: {
            userId
        },
        success: function (data) {
            $('.conversation-box').empty().html(data.view);
            initEmojiPicker();
            selectedImages = [];
            $('.chat_conversation').scrollTop($('.chat_conversation')[0].scrollHeight);
        },
        error: function () {
            toastr.error(conversationDataToJs.data('on-error-global-message'), {
                CloseButton: true,
                ProgressBar: true
            });
        }
    })
}

function replyConversation(url) {
    let form = document.querySelector('form');
    let formdata = new FormData(form);

    if (!formdata.get('reply') && !formdata.get('images[]')) {
        toastr.error(conversationDataToJs.data('on-empty-reply-and-image'), {
            CloseButton: true,
            ProgressBar: true
        });
        return "false";
    }

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $.ajax({
        url: url,
        type: 'POST',
        data: formdata,
        processData: false,
        contentType: false,
        success: function (data) {
            if (data.errors) {
                for (let i = 0; i < data.errors.length; i++) {
                    toastr.error(data.errors[i].message, {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            } else {
                toastr.success(data.message, {
                    CloseButton: true,
                    ProgressBar: true
                });
                $('.conversation-box').html(data.view);
                selectedImages = [];
                $('.chat_conversation').scrollTop($('.chat_conversation')[0].scrollHeight);
            }
            initEmojiPicker();
            getCustomerList();
        },
        error: function (data) {
            toastr.error(conversationDataToJs.data('on-error-global-message'), {
                CloseButton: true,
                ProgressBar: true
            });
        }
    });
}

let clickedIndex = 0;

$(document).on('click', '[data-target^="#imgViewModal"]', function () {
    clickedIndex = $(this).data('index');
});

$(document).on('shown.bs.modal', '.imgViewModal', function () {

    let $slider = $(this).find('.imgView-slider');

    if ($slider.hasClass('owl-loaded')) {
        $slider.trigger('destroy.owl.carousel');
        $slider.removeClass('owl-loaded owl-hidden');
    }

    $slider.owlCarousel({
        items: 1,
        loop: $slider.children().length > 1,
        nav: false,
        dots: false,
        smartSpeed: 300,
        startPosition: clickedIndex,
        mouseDrag: true,
        touchDrag: true,

        onInitialized: function (event) {
            $(event.target).removeClass('owl-hidden');
            counter(event);
        },

        onChanged: counter
    });

});

$(document).on('click', '.imgView-owl-next', function () {
    $(this).closest('.modal').find('.imgView-slider')
        .trigger('next.owl.carousel');
});

$(document).on('click', '.imgView-owl-prev', function () {
    $(this).closest('.modal').find('.imgView-slider')
        .trigger('prev.owl.carousel');
});

$(document).on('hidden.bs.modal', '.imgViewModal', function () {

    let $slider = $(this).find('.imgView-slider');

    if ($slider.hasClass('owl-loaded')) {
        $slider.trigger('destroy.owl.carousel');
        $slider.removeClass('owl-loaded');
    }

});

function counter(event) {

    var $slider = $(event.target);

    var total = event.item.count;

    var index = event.item.index - event.relatedTarget._clones.length / 2;

    if (index >= total) index -= total;
    if (index < 0) index += total;

    var current = index + 1;

    let $modal = $slider.closest('.imgViewModal');

    $modal.find(".imgView-counter .current").text(current);
    $modal.find(".imgView-counter .total").text(total);

    // 🔥 get image by calculated index (NOT .active)
    var $img = $slider.find('.owl-item').eq(event.item.index).find('img');

    var name = $img.data('name') || '';

    $modal.find('.show-img-title').text(name);
}

function singleFileDownload() {
    $(document).off("click", ".download--single-image").on("click", ".download--single-image", function (e) {
        e.preventDefault();

        const img = $(this)
            .closest(".zip-wrapper")
            .find(".zip-images img")
            .first();

        if (!img.length) {
            console.error("No image found for single download.");
            return;
        }

        const imgUrl = img.attr("src");
        const fileName = imgUrl.split("/").pop() || "image.png";

        fetch(imgUrl)
            .then(res => {
                if (!res.ok) throw new Error("Image fetch failed");
                return res.blob();
            })
            .then(blob => {
                const link = document.createElement("a");
                const url = URL.createObjectURL(blob);

                link.href = url;
                link.download = fileName;
                document.body.appendChild(link);
                link.click();

                document.body.removeChild(link);
                URL.revokeObjectURL(url);
            })
            .catch(err =>
                console.error("Single image download error:", err)
            );
    });
}

function downloadZip() {
    $(document).off("click", ".zip-download").on("click", ".zip-download", function(event) {
        console.log(132)
        event.preventDefault();

        const zipWrapper = $(this)
            .closest(".zip-wrapper")
            .find(".zip-images");
        if (!zipWrapper.length) {
            console.error("No .zip-images container found.");
            return;
        }

        const zip = new JSZip();
        const zipFolder = zip.folder("files");
        const images = zipWrapper.find("img");

        if (images.length === 0 && videos.length === 0) {
            console.error("No images or videos found to zip.");
            return;
        }

        // Fetch all images and videos and zip them
        const mediaPromises = [];

        images.each((index, img) => {
            const imgUrl = $(img).attr("src");
            const filename = `image_${index + 1}.png`;

            mediaPromises.push(
                fetch(imgUrl)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(
                                `Failed to fetch image: ${imgUrl}`
                            );
                        }
                        return response.blob();
                    })
                    .then(blob => zipFolder.file(filename, blob))
                    .catch(error =>
                        console.error(
                            `Error fetching image (${filename}):`,
                            error
                        )
                    )
            );
        });

        Promise.all(mediaPromises)
            .then(() => zip.generateAsync({ type: "blob" }))
            .then(content => saveAs(content, "files.zip"))
            .catch(error => console.error("Error generating ZIP:", error));
    });
}











